<?php
/**
 * @package     AISmartTalk
 * @subpackage  plg_system_aismarttalk
 * @copyright   Copyright (C) 2024 AI SmartTalk. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

$chatModelId = $displayData['chatModelId'];
$backofficeUrl = $displayData['backofficeUrl'];
$cdnUrl = $displayData['cdnUrl'];
$lang = $displayData['lang'];
?>

<div class="alert alert-info">
    <h4><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_BACKOFFICE_TITLE'); ?></h4>
    <p><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_BACKOFFICE_DESC'); ?></p>
    <a href="<?php echo htmlspecialchars($backofficeUrl, ENT_QUOTES, 'UTF-8'); ?>" 
       target="_blank" 
       class="btn btn-primary">
        <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_OPEN_BACKOFFICE'); ?>
    </a>
</div>

<!-- Content Synchronization Actions -->
<div class="alert alert-info">
    <h4><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_FIELDSET_SYNC'); ?></h4>
    <p><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_DESCRIPTION'); ?></p>
    
    <!-- Main Sync Button -->
    <div style="margin: 20px 0;">
        <a href="index.php?option=com_plugins&task=aismarttalk.syncAllContent" 
           class="btn btn-success btn-lg"
           style="font-size: 16px; padding: 12px 24px;"
           onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_ALL'); ?>');">
            <i class="icon-refresh"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_FORCE_SYNC_ALL'); ?>
        </a>
    </div>
    
    <hr style="margin: 20px 0;">
    
    <!-- Individual Sync Buttons -->
    <h5><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_INDIVIDUAL'); ?></h5>
    <div class="btn-toolbar" style="margin-top: 10px;">
        <div class="btn-group" style="margin-right: 10px; margin-bottom: 10px;">
            <a href="index.php?option=com_plugins&task=aismarttalk.syncAllProducts" 
               class="btn btn-primary"
               onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_PRODUCTS'); ?>');">
                <i class="icon-basket"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_PRODUCTS'); ?>
            </a>
        </div>
        
        <div class="btn-group" style="margin-right: 10px; margin-bottom: 10px;">
            <a href="index.php?option=com_plugins&task=aismarttalk.syncAllArticles" 
               class="btn btn-primary"
               onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_ARTICLES'); ?>');">
                <i class="icon-file-text"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_ARTICLES'); ?>
            </a>
        </div>
        
        <div class="btn-group" style="margin-right: 10px; margin-bottom: 10px;">
            <a href="index.php?option=com_plugins&task=aismarttalk.syncAllCategories" 
               class="btn btn-primary"
               onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_CATEGORIES'); ?>');">
                <i class="icon-folder"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_CATEGORIES'); ?>
            </a>
        </div>
    </div>
    
    <hr style="margin: 20px 0;">
    
    <!-- Clean Buttons -->
    <h5><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CLEAN_SECTION'); ?></h5>
    <p class="text-muted"><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CLEAN_DESCRIPTION'); ?></p>
    <div class="btn-toolbar" style="margin-top: 10px;">
        <div class="btn-group" style="margin-right: 10px; margin-bottom: 10px;">
            <a href="index.php?option=com_plugins&task=aismarttalk.cleanProducts" 
               class="btn btn-warning"
               onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_CLEAN_PRODUCTS'); ?>');">
                <i class="icon-trash"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CLEAN_PRODUCTS'); ?>
            </a>
        </div>
        
        <div class="btn-group" style="margin-right: 10px; margin-bottom: 10px;">
            <a href="index.php?option=com_plugins&task=aismarttalk.cleanArticles" 
               class="btn btn-warning"
               onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_CLEAN_ARTICLES'); ?>');">
                <i class="icon-trash"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CLEAN_ARTICLES'); ?>
            </a>
        </div>
        
        <div class="btn-group" style="margin-bottom: 10px;">
            <a href="index.php?option=com_plugins&task=aismarttalk.cleanCategories" 
               class="btn btn-warning"
               onclick="return confirm('<?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_CLEAN_CATEGORIES'); ?>');">
                <i class="icon-trash"></i> <?php echo Text::_('PLG_SYSTEM_AISMARTTALK_CLEAN_CATEGORIES'); ?>
            </a>
        </div>
    </div>
</div>

<script>
    window.chatbotSettings = {
        lang: "<?php echo htmlspecialchars($lang, ENT_QUOTES, 'UTF-8'); ?>"
    };
</script>
<script type="text/javascript" 
        src="<?php echo htmlspecialchars($cdnUrl, ENT_QUOTES, 'UTF-8'); ?>/cdn?chatModelId=<?php echo htmlspecialchars($chatModelId, ENT_QUOTES, 'UTF-8'); ?>" 
        async></script>
<div id="chatbot"><?php echo Text::_('PLG_SYSTEM_AISMARTTALK_LOADING'); ?>...</div>

