<?php
/**
 * @package     AISmartTalk
 * @subpackage  plg_system_aismarttalk
 * @copyright   Copyright (C) 2024 AI SmartTalk. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

class JFormFieldSyncbutton extends FormField
{
    protected $type = 'Syncbutton';

    protected function getInput()
    {
        $app = Factory::getApplication();
        $token = Session::getFormToken();
        $ajaxUrl = Uri::base() . 'index.php?option=com_ajax&plugin=aismarttalk&group=system&format=json&' . $token . '=1';

        $html = [];

        $html[] = '<style>
            .aismarttalk-sync-container {
                padding: 15px;
                background: #f5f5f5;
                border-radius: 8px;
                margin: 10px 0;
            }
            .aismarttalk-sync-container h4 {
                margin: 0 0 15px 0;
                color: #333;
                font-size: 14px;
                font-weight: 600;
            }
            .aismarttalk-sync-buttons {
                display: flex;
                flex-wrap: wrap;
                gap: 10px;
                margin-bottom: 15px;
            }
            .aismarttalk-sync-btn {
                display: inline-flex;
                align-items: center;
                gap: 8px;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 13px;
                font-weight: 500;
                transition: all 0.2s ease;
            }
            .aismarttalk-sync-btn:disabled {
                opacity: 0.6;
                cursor: not-allowed;
            }
            .aismarttalk-sync-btn-primary {
                background: #1a73e8;
                color: white;
            }
            .aismarttalk-sync-btn-primary:hover:not(:disabled) {
                background: #1557b0;
            }
            .aismarttalk-sync-btn-secondary {
                background: #5f6368;
                color: white;
            }
            .aismarttalk-sync-btn-secondary:hover:not(:disabled) {
                background: #3c4043;
            }
            .aismarttalk-sync-btn .spinner {
                display: none;
                width: 14px;
                height: 14px;
                border: 2px solid transparent;
                border-top-color: currentColor;
                border-radius: 50%;
                animation: spin 0.8s linear infinite;
            }
            .aismarttalk-sync-btn.loading .spinner {
                display: inline-block;
            }
            .aismarttalk-sync-btn.loading .btn-text {
                opacity: 0.7;
            }
            @keyframes spin {
                to { transform: rotate(360deg); }
            }
            .aismarttalk-sync-result {
                margin-top: 15px;
                padding: 12px 15px;
                border-radius: 5px;
                display: none;
            }
            .aismarttalk-sync-result.success {
                display: block;
                background: #d4edda;
                color: #155724;
                border: 1px solid #c3e6cb;
            }
            .aismarttalk-sync-result.error {
                display: block;
                background: #f8d7da;
                color: #721c24;
                border: 1px solid #f5c6cb;
            }
            .aismarttalk-sync-section {
                margin-bottom: 20px;
            }
            .aismarttalk-sync-section:last-child {
                margin-bottom: 0;
            }
            .aismarttalk-sync-section-title {
                font-size: 12px;
                color: #666;
                margin-bottom: 10px;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }
        </style>';

        $html[] = '<div class="aismarttalk-sync-container">';
        
        $html[] = '<div class="aismarttalk-sync-section">';
        $html[] = '<div class="aismarttalk-sync-section-title">' . Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_DESCRIPTION') . '</div>';
        $html[] = '<div class="aismarttalk-sync-buttons">';
        $html[] = '<button type="button" class="aismarttalk-sync-btn aismarttalk-sync-btn-primary" onclick="aismarttalkSync(\'all\')" id="btn-sync-all">';
        $html[] = '<span class="spinner"></span>';
        $html[] = '<span class="btn-text">' . Text::_('PLG_SYSTEM_AISMARTTALK_FORCE_SYNC_ALL') . '</span>';
        $html[] = '</button>';
        $html[] = '</div>';
        $html[] = '</div>';

        $html[] = '<div class="aismarttalk-sync-section">';
        $html[] = '<div class="aismarttalk-sync-section-title">' . Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_INDIVIDUAL') . '</div>';
        $html[] = '<div class="aismarttalk-sync-buttons">';
        $html[] = '<button type="button" class="aismarttalk-sync-btn aismarttalk-sync-btn-secondary" onclick="aismarttalkSync(\'products\')" id="btn-sync-products">';
        $html[] = '<span class="spinner"></span>';
        $html[] = '<span class="btn-text">' . Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_PRODUCTS') . '</span>';
        $html[] = '</button>';
        $html[] = '<button type="button" class="aismarttalk-sync-btn aismarttalk-sync-btn-secondary" onclick="aismarttalkSync(\'articles\')" id="btn-sync-articles">';
        $html[] = '<span class="spinner"></span>';
        $html[] = '<span class="btn-text">' . Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_ARTICLES') . '</span>';
        $html[] = '</button>';
        $html[] = '<button type="button" class="aismarttalk-sync-btn aismarttalk-sync-btn-secondary" onclick="aismarttalkSync(\'categories\')" id="btn-sync-categories">';
        $html[] = '<span class="spinner"></span>';
        $html[] = '<span class="btn-text">' . Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_CATEGORIES') . '</span>';
        $html[] = '</button>';
        $html[] = '</div>';
        $html[] = '</div>';

        $html[] = '<div id="aismarttalk-sync-result" class="aismarttalk-sync-result"></div>';
        $html[] = '</div>';

        $html[] = '<script>
        function aismarttalkGetSelectedContentTypes() {
            // Get the current state of checkboxes from the form (not saved values)
            var selected = [];
            var checkboxes = document.querySelectorAll("input[name=\"jform[params][content_types][]\"]");
            checkboxes.forEach(function(cb) {
                if (cb.checked) {
                    selected.push(cb.value);
                }
            });
            return selected;
        }

        function aismarttalkSync(type) {
            var confirmMessages = {
                "all": "' . Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_ALL', true) . '",
                "products": "' . Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_PRODUCTS', true) . '",
                "articles": "' . Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_ARTICLES', true) . '",
                "categories": "' . Text::_('PLG_SYSTEM_AISMARTTALK_CONFIRM_SYNC_CATEGORIES', true) . '"
            };

            // Get currently selected content types from form
            var selectedTypes = aismarttalkGetSelectedContentTypes();

            // Check if any content types are selected
            if (selectedTypes.length === 0) {
                var resultDiv = document.getElementById("aismarttalk-sync-result");
                resultDiv.className = "aismarttalk-sync-result error";
                resultDiv.textContent = "' . Text::_('PLG_SYSTEM_AISMARTTALK_AJAX_NO_CONTENT_TYPES', true) . '";
                resultDiv.style.display = "block";
                return;
            }

            // For individual sync, check if that specific type is selected
            if (type !== "all" && selectedTypes.indexOf(type) === -1) {
                var resultDiv = document.getElementById("aismarttalk-sync-result");
                resultDiv.className = "aismarttalk-sync-result error";
                resultDiv.textContent = "' . Text::_('PLG_SYSTEM_AISMARTTALK_SYNC_TYPE_NOT_CHECKED', true) . '";
                resultDiv.style.display = "block";
                return;
            }

            if (!confirm(confirmMessages[type])) {
                return;
            }

            var btn = document.getElementById("btn-sync-" + type);
            var resultDiv = document.getElementById("aismarttalk-sync-result");
            var allButtons = document.querySelectorAll(".aismarttalk-sync-btn");

            allButtons.forEach(function(b) { b.disabled = true; });
            btn.classList.add("loading");
            resultDiv.className = "aismarttalk-sync-result";
            resultDiv.style.display = "none";

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "' . $ajaxUrl . '&task=sync&sync_type=" + type, true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    allButtons.forEach(function(b) { b.disabled = false; });
                    btn.classList.remove("loading");

                    console.log("AISmartTalk AJAX Response:", xhr.responseText);

                    try {
                        var response = JSON.parse(xhr.responseText);
                        // com_ajax wraps the response in a data property
                        var data = response.data || response;

                        // Handle array response from com_ajax
                        if (Array.isArray(data) && data.length > 0) {
                            data = data[0];
                        }

                        if (data && data.success) {
                            resultDiv.className = "aismarttalk-sync-result success";
                            resultDiv.textContent = data.message || "' . Text::_('PLG_SYSTEM_AISMARTTALK_MSG_SYNC_SUCCESS', true) . '";
                        } else {
                            resultDiv.className = "aismarttalk-sync-result error";
                            resultDiv.textContent = (data && data.message) ? data.message : "' . Text::_('PLG_SYSTEM_AISMARTTALK_MSG_SYNC_ERROR', true) . '";
                        }
                    } catch (e) {
                        console.error("AISmartTalk AJAX Parse Error:", e, xhr.responseText);
                        resultDiv.className = "aismarttalk-sync-result error";
                        resultDiv.textContent = "' . Text::_('PLG_SYSTEM_AISMARTTALK_MSG_SYNC_ERROR', true) . '";
                    }
                    resultDiv.style.display = "block";
                }
            };

            // Send selected content types with the request
            var postData = "content_types=" + encodeURIComponent(JSON.stringify(selectedTypes));
            xhr.send(postData);
        }
        </script>';

        return implode("\n", $html);
    }

    protected function getLabel()
    {
        return '';
    }
}

