<?php
/**
 * @package     AISmartTalk
 * @subpackage  plg_system_aismarttalk
 * @copyright   Copyright (C) 2024 AI SmartTalk. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Uri\Uri;

class JFormFieldPluginheader extends FormField
{
    protected $type = 'Pluginheader';

    protected function getInput()
    {
        $logoUrl = Uri::root() . 'media/plg_system_aismarttalk/aismarttalk.png';
        $pluginLogoUrl = Uri::root() . 'plugins/system/aismarttalk/aismarttalk.png';
        
        $html = [];
        
        $html[] = '<style>
            .aismarttalk-banner {
                display: flex;
                align-items: center;
                gap: 16px;
                padding: 16px 20px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 10px;
                margin: -10px 0 15px 0;
            }
            .aismarttalk-banner-logo {
                width: 56px;
                height: 56px;
                object-fit: contain;
                border-radius: 10px;
                background: white;
                padding: 6px;
                flex-shrink: 0;
            }
            .aismarttalk-banner-content {
                flex: 1;
                min-width: 0;
            }
            .aismarttalk-banner-title {
                font-size: 18px;
                font-weight: 600;
                color: #fff;
                margin: 0 0 4px 0;
                display: flex;
                align-items: center;
                gap: 8px;
                flex-wrap: wrap;
            }
            .aismarttalk-banner-version {
                display: inline-block;
                background: rgba(255,255,255,0.2);
                color: white;
                font-size: 11px;
                font-weight: 500;
                padding: 2px 8px;
                border-radius: 12px;
            }
            .aismarttalk-banner-links {
                display: flex;
                gap: 12px;
                flex-wrap: wrap;
            }
            .aismarttalk-banner-link {
                display: inline-flex;
                align-items: center;
                gap: 4px;
                color: rgba(255,255,255,0.9);
                text-decoration: none;
                font-size: 12px;
                transition: color 0.2s;
            }
            .aismarttalk-banner-link:hover {
                color: #fff;
                text-decoration: none;
            }
        </style>';
        
        $html[] = '<div class="aismarttalk-banner">';
        $html[] = '<img src="' . $pluginLogoUrl . '" alt="AI SmartTalk" class="aismarttalk-banner-logo" onerror="this.src=\'' . $logoUrl . '\'">';
        $html[] = '<div class="aismarttalk-banner-content">';
        $html[] = '<div class="aismarttalk-banner-title">AI SmartTalk <span class="aismarttalk-banner-version">v1.5.0</span></div>';
        $html[] = '<div class="aismarttalk-banner-links">';
        $html[] = '<a href="https://aismarttalk.tech" target="_blank" class="aismarttalk-banner-link">🌐 Website</a>';
        $html[] = '<a href="https://aismarttalk.tech/docs" target="_blank" class="aismarttalk-banner-link">📖 Docs</a>';
        $html[] = '</div>';
        $html[] = '</div>';
        $html[] = '</div>';
        
        return implode("\n", $html);
    }

    protected function getLabel()
    {
        return '';
    }
}

